﻿var panelPointCommon = {
    resetTransactionContent: function () {
        $("#Points", panelPointCommon.context).val("");
        $("#Message", panelPointCommon.context).val("");
        $(".v-newTransactionContent", panelPointCommon.context).hide();
        $("#pageHeaderOptions", panelPointCommon.context).show();
    },
    addTransactionPointToPanelist: function (actionType, actionMethod, actionContext) {
        a4.hideErrorMessage();
        var points = parseInt($("#Points", panelPointCommon.context).val(), 10);
        var op = $("#Operation", panelPointCommon.context).val();

        if (!points || isNaN(points) || points.length == 0) {
            a4.showErrorMessage(resources.PointsRequired);
        }
        else {
            a4.showBusyBox();
            var tableParams, panelistFilter, panelistId, selectedPanelistsJson = '';

            if (actionType == 'Single') {
                panelistId = actionContext.panelistId;
            }
            else {
                tableParams = JSON.stringify(actionContext.datatable.a4datatable("getTableParams"));
                panelistFilter = actionContext.filterDefinition;
                selectedPanelistsJson = $("#SelectedPanelistsJson").val();
            }

            a4.callServerMethod(a4.getAction(actionMethod, "Panelists", "Panel"),
                {
                    "panelistPointTransaction": {
                            panelId: $("#survey-block", top.panelists.context).attr("data-panelid"),
                            panelistId: panelistId,
                            PanelistFilter: panelistFilter,
                            TableParams: tableParams,
                            operation: op,
                            points: points,
                            message: $("#Message", panelPointCommon.context).val(),
                        ActionType: actionType,
                        SelectedPanelistsJson: selectedPanelistsJson
                    }
                },
                function (result) {
                    a4.hideBusyBox();

                    if (result.message) {
                        if (result.success) {
                            a4.showSuccessMessage(result.message);
                        }
                        else {
                            a4.showErrorMessage(result.message);
                        }
                    }

                    actionContext.datatable.a4datatable("refresh"); 

                    if (result.refresh) {
                        if (actionType == 'Single') {
                            var totalField = $(".v-pointsTotal", panelistPoints.context);
                            var total = parseInt(totalField.text(), 10);

                            total = (op == "Debit") ? (total - points) : (total + points);
                            totalField.text(total);
                        }

                        panelPointCommon.resetTransactionContent();

                        if (top.panelists) {
                            top.panelists.refreshContent();
                        }
                    }
                },
                function (error) {
                    a4.hideBusyBox();
                    a4.onAjaxPageMethodError(error);
                });
        }
    },
    bindEvents: function () {
        $(document).on("click", ".h-newPointTransaction", function () {
            var button = $(this);

            $("#pageHeaderOptions", panelPointCommon.context).hide();
            $(".v-newTransactionContent", panelPointCommon.context).show();

            //$("select", panelPointCommon.context).focus(); // Hack for rendering issue, otherwise spacing occurs on hover of input
        });

        $(document).on("click", ".h-cancelTransaction", function () {
            panelPointCommon.resetTransactionContent();
        });

        $(document).on("keydown", ".v-validatePositiveInt", function (event) {
            a4.validateNumberKeyCode(event, false);
        });

    }
}

$(document).ready(function () {
    panelPointCommon.bindEvents();
});
